//
//  InstanceProvider.h
//  dJAX
//
//  Copyright (c) 2015 dJAX. All rights reserved.
//

#import "Global.h"
#import "CoreInstanceProvider.h"

// WebView
@class WebView;
@protocol WebViewDelegate;

// Banners
@class MPBannerAdManager;
@protocol MPBannerAdManagerDelegate;
@class MPBaseBannerAdapter;
@protocol MPBannerAdapterDelegate;
@class MPBannerCustomEvent;
@protocol MPBannerCustomEventDelegate;

// Interstitials
@class MPInterstitialAdManager;
@protocol MPInterstitialAdManagerDelegate;
@class MPBaseInterstitialAdapter;
@protocol MPInterstitialAdapterDelegate;
@class MPInterstitialCustomEvent;
@protocol MPInterstitialCustomEventDelegate;
@class MPHTMLInterstitialViewController;
@class MPMRAIDInterstitialViewController;
@protocol MPInterstitialViewControllerDelegate;

// Rewarded Video
@class MPRewardedVideoAdManager;
@class MPRewardedVideoAdapter;
@class MPRewardedVideoCustomEvent;
@protocol MPRewardedVideoAdapterDelegate;
@protocol MPRewardedVideoCustomEventDelegate;
@protocol MPRewardedVideoAdManagerDelegate;

// HTML Ads
@class AdWebViewAgent;
@protocol AdWebViewAgentDelegate;

// MRAID
@class MRController;
@protocol MRControllerDelegate;
@class ClosableView;
@class MRBridge;
@protocol MRBridgeDelegate;
@protocol ClosableViewDelegate;
@class MRBundleManager;
@class MRVideoPlayerManager;
@protocol MRVideoPlayerManagerDelegate;
@class MPMoviePlayerViewController;
@class MRNativeCommandHandler;
@protocol MRNativeCommandHandlerDelegate;

//Native
@protocol NativeCustomEventDelegate;
@class lpxNativeCustomEvent;
@class NativeAdSource;
@protocol NativeAdSourceDelegate;
@class NativePositionSource;
@class StreamAdPlacementData;
@class StreamAdPlacer;
@class AdPositioning;
@protocol NativeAdRenderer;

@interface InstanceProvider : NSObject

+(instancetype)sharedProvider;
- (id)singletonForClass:(Class)klass provider:(MPSingletonProviderBlock)provider;
- (id)singletonForClass:(Class)klass provider:(MPSingletonProviderBlock)provider context:(id)context;

#pragma mark - Banners
- (MPBannerAdManager *)buildMPBannerAdManagerWithDelegate:(id<MPBannerAdManagerDelegate>)delegate;
- (MPBaseBannerAdapter *)buildBannerAdapterForConfiguration:(AdConfiguration *)configuration
                                                   delegate:(id<MPBannerAdapterDelegate>)delegate;
- (MPBannerCustomEvent *)buildBannerCustomEventFromCustomClass:(Class)customClass
                                                      delegate:(id<MPBannerCustomEventDelegate>)delegate;

#pragma mark - Interstitials
- (MPInterstitialAdManager *)buildMPInterstitialAdManagerWithDelegate:(id<MPInterstitialAdManagerDelegate>)delegate;
- (MPBaseInterstitialAdapter *)buildInterstitialAdapterForConfiguration:(AdConfiguration *)configuration
                                                               delegate:(id<MPInterstitialAdapterDelegate>)delegate;
- (MPInterstitialCustomEvent *)buildInterstitialCustomEventFromCustomClass:(Class)customClass
                                                                  delegate:(id<MPInterstitialCustomEventDelegate>)delegate;
- (MPHTMLInterstitialViewController *)buildMPHTMLInterstitialViewControllerWithDelegate:(id<MPInterstitialViewControllerDelegate>)delegate
                                                                        orientationType:(dJAXInterstitialOrientationType)type;
- (MPMRAIDInterstitialViewController *)buildMPMRAIDInterstitialViewControllerWithDelegate:(id<MPInterstitialViewControllerDelegate>)delegate
                                                                            configuration:(AdConfiguration *)configuration;

#pragma mark - Rewarded Video
- (MPRewardedVideoAdManager *)buildRewardedVideoAdManagerWithAdUnitID:(NSString *)adUnitID delegate:(id<MPRewardedVideoAdManagerDelegate>)delegate;
- (MPRewardedVideoAdapter *)buildRewardedVideoAdapterWithDelegate:(id<MPRewardedVideoAdapterDelegate>)delegate;
- (MPRewardedVideoCustomEvent *)buildRewardedVideoCustomEventFromCustomClass:(Class)customClass delegate:(id<MPRewardedVideoCustomEventDelegate>)delegate;


#pragma mark - HTML Ads
- (AdWebViewAgent *)buildAdWebViewAgentWithAdWebViewFrame:(CGRect)frame
                                                     delegate:(id<AdWebViewAgentDelegate>)delegate;



#pragma mark - Native

- (lpxNativeCustomEvent *)buildNativeCustomEventFromCustomClass:(Class)customClass
                                                      delegate:(id<NativeCustomEventDelegate>)delegate;
- (NativeAdSource *)buildNativeAdSourceWithDelegate:(id<NativeAdSourceDelegate>)delegate;
- (NativePositionSource *)buildNativePositioningSource;
- (StreamAdPlacementData *)buildStreamAdPlacementDataWithPositioning:(AdPositioning *)positioning;
- (StreamAdPlacer *)buildStreamAdPlacerWithViewController:(UIViewController *)controller adPositioning:(AdPositioning *)positioning rendererConfigurations:(NSArray *)rendererConfigurations;

@end
